#include <bits/stdc++.h>

using namespace std;

const int N = 1e5 + 10, L = 20;
const int inf = 1e9;

struct Seg {
    int st[4 * N];
    void update(int index, int l, int r, int x, int val) {
        if(l > r || r < x || x < l) return;
        if(l == r) {
            st[index] = val;
            return;
        }
        int mid = (l + r) / 2;
        update(2 * index, l, mid, x, val);
        update(2 * index + 1, mid + 1, r, x, val);
        st[index] = min(st[2 * index], st[2 * index + 1]);
    }
    int getL(int index, int l, int r, int x) {
        if(l > r || l > x) return -inf;
        int mid = (l + r) / 2;
        if(l == r) {
            if(st[index] == 0) return l;
            return -inf;
        }
        if(r > x) return max(getL(2 * index, l, mid, x), getL(2 * index + 1, mid + 1, r, x));
        if(st[index] == 1) return -inf;
        if(st[2 * index + 1] == 0) return getL(2 * index + 1, mid + 1, r, x);
        return getL(2 * index, l, mid, x);
    }
    int getR(int index, int l, int r, int x) {
        if(l > r || r < x) return inf;
        int mid = (l + r) / 2;
        if(l == r) {
            if(st[index] == 0) return r;
            return inf;
        }
        if(l < x) return min(getR(2 * index, l, mid, x), getR(2 * index + 1, mid + 1, r, x));
        if(st[index] == 1) return inf;
        if(st[2 * index] == 0) return getR(2 * index, l, mid, x);
        return getR(2 * index + 1, mid + 1, r, x);
    }
};

int n, q;
int a[N];
Seg st[L];

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cin >> n;
    for(int i = 1; i <= n; i++) {
        cin >> a[i];
        for(int j = 0; j < L; j++) st[j].update(1, 1, n, i, (((1 << j) & a[i]) > 0));
    }
    cin >> q;
    while(q--) {
        int t;
        cin >> t;
        if(t == 1) {
            int x, val;
            cin >> x >> val;
            for(int j = 0; j < L; j++) st[j].update(1, 1, n, x, (((1 << j) & val) > 0));
        } else {
            int x;
            cin >> x;
            vector<pair<int, int>> left(L), right(L);
            for(int i = 0; i < L; i++) {
                left[i].first = st[i].getL(1, 1, n, x);
                right[i].first = st[i].getR(1, 1, n, x);
                left[i].second = i;
                right[i].second = i;
            }
            bool ok = true;
            for(int i = 0; i < L; i++) {
                if(left[i].first == -inf && right[i].first == inf) {
                    cout << "-1\n";
                    ok = false;
                    break;
                }
            }
            if(!ok) continue;
            sort(left.rbegin(), left.rend());
            sort(right.begin(), right.end());
            int res = min(x - left.back().first, right.back().first - x);
            int j = L - 1;
            vector<int> cnt(L, 1);
            int have = L;
            for(int i = 0; i < L; i++) {
                if(cnt[left[i].second] == 0) have++;
                cnt[left[i].second]++;
                while(j > 0 && have == L) {
                    if(cnt[right[j].second] == 1) have--;
                    cnt[right[j].second]--;
                    j--;
                }
                if(have < L) {
                    j++;
                    cnt[right[j].second]++;
                    if(cnt[right[j].second] == 1) have++;
                }
                res = min(res, 2 * (x - left[i].first) + (right[j].first - x));
                res = min(res, (x - left[i].first) + 2 * (right[j].first - x));
            }
            cout << res << "\n";
        }
    }
    return 0;
}